/*
 * File:		sysinit.c
 * Purpose:		Reset configuration of the M5282EVB
 *
 * Notes:		
 */

#include "src/init/m5282evb.h"

/********************************************************************/
void
mcf5282_init(void)
{
	int i;
	void mcf5282_pll_init(void);
	void mcf5282_uart_init(void);
	void mcf5282_scm_init(void);
	void mcf5282_cs_init(void);
	void mcf5282_sdram_init(void);
	void mcf5282_can_init(void);
	
	extern char __DATA_ROM[];
	extern char __DATA_RAM[];
	extern char __DATA_END[];
	extern char __BSS_START[];
	extern char __BSS_END[];
	extern uint32 VECTOR_TABLE[];
	extern uint32 __VECTOR_RAM[];
	uint32 n;
	uint8 *dp, *sp;

	/* turn off watchdog timer */
	MCF5282_WTM_WCR = 0x0000;

	
	MCF5282_GPIO_PBCDPAR = 0xC0;
	

	mcf5282_pll_init();
	mcf5282_scm_init();
	mcf5282_uart_init();
	mcf5282_cs_init();
	mcf5282_sdram_init();
	mcf5282_can_init();
	
//	mcf5xxx_wr_acr0(0xFF00C000);
	
	/* Turn Instruction Cache ON */
//	mcf5xxx_wr_cacr(0
//		| MCF5XXX_CACR_CENB
//		| MCF5XXX_CACR_CINV
//		| MCF5XXX_CACR_DISD
//		| MCF5XXX_CACR_CLNF_00);
		
	/* Invalidate all */	
//	mcf5xxx_wr_cacr(0 | MCF5XXX_CACR_CINV);		
		
//	/* wait */
//	for(i=0;i<1000000;i++);

//	/* Turn Instruction Cache ON */
//	mcf5xxx_wr_cacr(0
//		| MCF5XXX_CACR_CENB
//		| MCF5XXX_CACR_DBWE);	
		
		
	/* Copy the vector table to RAM */
	if (__VECTOR_RAM != VECTOR_TABLE)
	{
		for (n = 0; n < 256; n++)
			__VECTOR_RAM[n] = VECTOR_TABLE[n];
	}
    mcf5xxx_wr_vbr((uint32)__VECTOR_RAM);


	/* Move initialized data from ROM to RAM. */
	if (__DATA_ROM != __DATA_RAM)
	{
		dp = (uint8 *)__DATA_RAM;
		sp = (uint8 *)__DATA_ROM;
		n = __DATA_END - __DATA_RAM;
		while (n--)
			*dp++ = *sp++;
	}
 
	/* Zero uninitialized data */
	if (__BSS_START != __BSS_END)
	{
		sp = (uint8 *)__BSS_START;
		n = __BSS_END - __BSS_START;
		while (n--)
			*sp++ = 0;
	}
}
/********************************************************************/
void 
mcf5282_pll_init(void)
{
	/*
	 * Multiply 8Mhz reference crystal by 8 to acheive system clock of 64Mhz.
	 */
	MCF5282_CLOCK_SYNCR = MCF5282_CLOCK_SYNCR_MFD(2);
	
	while (!(MCF5282_CLOCK_SYNSR & MCF5282_CLOCK_SYNSR_LOCK));
}

/****************************************************************/
void
mcf5282_scm_init(void)
{

}

/********************************************************************/
void
mcf5282_uart_init(void)
{
	/*
	 * Initialize all three UARTs for serial communications
	 */
	 
	register uint16 ubgs;
	
	/* Set Port UA to initialize URXD0/URXD1 UTXD0/UTXD1 */
	MCF5282_GPIO_PUAPAR = 0x0F;

	/* Reset Transmitter */
	MCF5282_UART0_UCR = MCF5282_UART_UCR_RESET_TX;
	MCF5282_UART1_UCR = MCF5282_UART_UCR_RESET_TX;
	MCF5282_UART2_UCR = MCF5282_UART_UCR_RESET_TX;

	/* Reset Receiver */
	MCF5282_UART0_UCR = MCF5282_UART_UCR_RESET_RX;
	MCF5282_UART1_UCR = MCF5282_UART_UCR_RESET_RX;
	MCF5282_UART2_UCR = MCF5282_UART_UCR_RESET_RX;

	/* Reset Mode Register */
	MCF5282_UART0_UCR = MCF5282_UART_UCR_RESET_MR;
	MCF5282_UART1_UCR = MCF5282_UART_UCR_RESET_MR;
	MCF5282_UART2_UCR = MCF5282_UART_UCR_RESET_MR;

	/* No parity, 8-bits per character */
	MCF5282_UART0_UMR = (0
		| MCF5282_UART_UMR1_PM_NONE
		| MCF5282_UART_UMR1_BC_8 );
	MCF5282_UART1_UMR = (0
		| MCF5282_UART_UMR1_PM_NONE
		| MCF5282_UART_UMR1_BC_8 );
	MCF5282_UART2_UMR = (0
		| MCF5282_UART_UMR1_PM_NONE
		| MCF5282_UART_UMR1_BC_8 );

	/* No echo or loopback, 1 stop bit */
	MCF5282_UART0_UMR = (0
		| MCF5282_UART_UMR2_CM_NORMAL
		| MCF5282_UART_UMR2_STOP_BITS_1);
	MCF5282_UART1_UMR = (0
		| MCF5282_UART_UMR2_CM_NORMAL
		| MCF5282_UART_UMR2_STOP_BITS_1);
	MCF5282_UART2_UMR = (0
		| MCF5282_UART_UMR2_CM_NORMAL
		| MCF5282_UART_UMR2_STOP_BITS_1);

	/* Set Rx and Tx baud by timer */
	MCF5282_UART0_UCSR = (0
		| MCF5282_UART_UCSR_RCS_SYS_CLK
		| MCF5282_UART_UCSR_TCS_SYS_CLK);
	MCF5282_UART1_UCSR = (0
		| MCF5282_UART_UCSR_RCS_SYS_CLK
		| MCF5282_UART_UCSR_TCS_SYS_CLK);
	MCF5282_UART2_UCSR = (0
		| MCF5282_UART_UCSR_RCS_SYS_CLK
		| MCF5282_UART_UCSR_TCS_SYS_CLK);

	/* Mask all UART interrupts */
	MCF5282_UART0_UIMR = 0;
	MCF5282_UART1_UIMR = 0;
	MCF5282_UART2_UIMR = 0;
                 
	/* Calculate baud settings */
	ubgs = (uint16)((SYSTEM_CLOCK*1000000)/(UART_BAUD * 32));

	MCF5282_UART0_UBG1 = (uint8)((ubgs & 0xFF00) >> 8);
	MCF5282_UART0_UBG2 = (uint8)(ubgs & 0x00FF);
	MCF5282_UART1_UBG1 = (uint8)((ubgs & 0xFF00) >> 8);
	MCF5282_UART1_UBG2 = (uint8)(ubgs & 0x00FF);
	MCF5282_UART2_UBG1 = (uint8)((ubgs & 0xFF00) >> 8);
	MCF5282_UART2_UBG2 = (uint8)(ubgs & 0x00FF);

	/* Enable receiver and transmitter */
	MCF5282_UART0_UCR = (0
		| MCF5282_UART_UCR_TX_ENABLED
		| MCF5282_UART_UCR_RX_ENABLED);
	MCF5282_UART1_UCR = (0
		| MCF5282_UART_UCR_TX_ENABLED
		| MCF5282_UART_UCR_RX_ENABLED);
	MCF5282_UART2_UCR = (0
		| MCF5282_UART_UCR_TX_ENABLED
		| MCF5282_UART_UCR_RX_ENABLED);
}
/********************************************************************/
void
mcf5282_sdram_init(void)
{
	int i;

//	for (i = 0; i < 200; i++)
//	{
//		#ifndef __MWERKS__
//			asm(" nop");
//			#else
//				asm( nop);
//			#endif
//	}

	if (!(MCF5282_SDRAMC_DACR0 & MCF5282_SDRAMC_DACR_RE))
	{
		/* 
		 * Initialize DRAM Control Register: DCR 
		 */
		MCF5282_SDRAMC_DCR = (0
			| MCF5282_SDRAMC_DCR_RTIM_6
			| MCF5282_SDRAMC_DCR_RC((15 * SYSTEM_CLOCK)>>4));

		/* 
		 * Initialize DACR0
		 */
		MCF5282_SDRAMC_DACR0 = (0
			| MCF5282_SDRAMC_DACR_BASE(SDRAM_ADDRESS)
			| MCF5282_SDRAMC_DACR_CASL(2)
			| MCF5282_SDRAMC_DACR_CBM(3)
			| MCF5282_SDRAMC_DACR_PS_32);
			
		/*
		 * Initialize DMR0
		 */
		MCF5282_SDRAMC_DMR0 = (0
			| MCF5282_SDRAMC_DMR_BAM_16M
			| MCF5282_SDRAMC_DMR_V);

		/*	
		 * Set IP (bit 3) in DACR 
		 */
		MCF5282_SDRAMC_DACR0 |= MCF5282_SDRAMC_DACR_IP;

		/*	
		 * Write to this block to initiate precharge 
		 */
		*(uint32 *)(SDRAM_ADDRESS) = 0xA5A59696;

		/* 
		 * Wait for at least 8 auto refresh cycles to occur 
		 */
//		for (i = 0; i < 200; i++)
//		{
//			#ifndef __MWERKS__
//				asm(" nop");
//				#else
//					asm( nop);
//				#endif
//		}

		/*	
		 * Set RE (bit 15) in DACR 
		 */
		MCF5282_SDRAMC_DACR0 |= MCF5282_SDRAMC_DACR_RE;
			

		/*	
		 * Finish the configuration by issuing the IMRS. 
		 */
		MCF5282_SDRAMC_DACR0 |= MCF5282_SDRAMC_DACR_IMRS;
	
		/* 
		 * Wait for at least 8 auto refresh cycles to occur 
		 */
//		for (i = 0; i < 200; i++)
//		{
//			#ifndef __MWERKS__
//				asm(" nop");
//				#else
//					asm( nop);
//				#endif
//		}
	
		
		/*
		 * Write to the SDRAM Mode Register 
		 */
		*(uint32 *)(SDRAM_ADDRESS + 0x400) = 0xA5A59696;
	}
}
/********************************************************************/
void
mcf5282_cs_init(void)
{
	/* 
	 * ChipSelect 1 - External SRAM 
	 */
	MCF5282_CS1_CSAR = 0x3000;
	MCF5282_CS1_CSMR = 0x00070001;
	MCF5282_CS1_CSCR = 0x1900;
	
	/* 
	 * ChipSelect 0 - External Flash 
	 */ 
	//MCF5282_CS0_CSAR = MCF5282_CS_CSAR(EXT_FLASH_ADDRESS);
	MCF5282_CS0_CSAR = 0xFFE0;

	MCF5282_CS0_CSCR = (0
		| MCF5282_CS_CSCR_WS(6)
		| MCF5282_CS_CSCR_AA
		| MCF5282_CS_CSCR_PS_16);
	MCF5282_CS0_CSMR = MCF5282_CS_CSMR_BAM_2M | MCF5282_CS_CSMR_V;
}

/********************************************************************/
void
mcf5282_can_init(void)
{
	/*
	 *   Initialize all operating modes
	 */
	
	MCF5282_FLEXCAN_CANMCR = (0
		| MCF5282_FLEXCAN_CANMCR_FRZ
		| MCF5282_FLEXCAN_CANMCR_HALT
		| MCF5282_FLEXCAN_CANMCR_SELFWAKE);
		
	MCF5282_FLEXCAN_CANCTRL0 = (0
		| MCF5282_FLEXCAN_CANCTRL0_RXMODE);
		
	MCF5282_FLEXCAN_CANCTRL1 = (1
		| MCF5282_FLEXCAN_CANCTRL1_LOM);
	
	/* sets S-clock rate to 500Khz */	
	MCF5282_FLEXCAN_PRESDIV = 0x83;
	
	
	/*  Initialize Message Buffers */
 
	MCF5282_FLEXCAN_MBUF0_CTRL = 0x0088;
	MCF5282_FLEXCAN_MBUF1_CTRL = 0x0000;
	MCF5282_FLEXCAN_MBUF2_CTRL = 0x0088;
	MCF5282_FLEXCAN_MBUF3_CTRL = 0x0088;
	MCF5282_FLEXCAN_MBUF4_CTRL = 0x0088;
	MCF5282_FLEXCAN_MBUF5_CTRL = 0x0088;
	MCF5282_FLEXCAN_MBUF6_CTRL = 0x0088;
	MCF5282_FLEXCAN_MBUF7_CTRL = 0x0088;
	MCF5282_FLEXCAN_MBUF8_CTRL = 0x0088;
	MCF5282_FLEXCAN_MBUF9_CTRL = 0x0000;
	MCF5282_FLEXCAN_MBUF10_CTRL = 0x0000;
	MCF5282_FLEXCAN_MBUF11_CTRL = 0x0000;
	MCF5282_FLEXCAN_MBUF12_CTRL = 0x0000;
	MCF5282_FLEXCAN_MBUF13_CTRL = 0x0000;
	MCF5282_FLEXCAN_MBUF14_CTRL = 0x0000;
	MCF5282_FLEXCAN_MBUF15_CTRL = 0x0000;

	/* Initialize Receive Mask Register */  
	MCF5282_FLEXCAN_RXGMASK = 0xFFE00000; 
	
	
	/* Synchronize FlexCan with CAN bus */
	MCF5282_FLEXCAN_CANMCR = (0
	    | MCF5282_FLEXCAN_CANMCR_FRZ
		| MCF5282_FLEXCAN_CANMCR_SELFWAKE);
	
	
	}
		